/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table;

import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.field.OutgoingReferenceEndpoint;
import ghidra.util.table.field.ReferenceEndpoint;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class IncomingReferencesTableModel
extends AddressBasedTableModel<ReferenceEndpoint> {
    private List<OutgoingReferenceEndpoint> refs;

    public IncomingReferencesTableModel(String title, ServiceProvider serviceProvider, Program program, List<OutgoingReferenceEndpoint> references, TaskMonitor monitor) {
        super(title, serviceProvider, program, monitor);
        this.refs = references;
    }

    @Override
    public Address getAddress(int row) {
        return ((ReferenceEndpoint)this.getRowObject(row)).getAddress();
    }

    protected void doLoad(Accumulator<ReferenceEndpoint> accumulator, TaskMonitor monitor) throws CancelledException {
        this.refs.forEach(r -> accumulator.add(r));
    }
}

