/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.replace.handler;

import ghidra.features.base.quickfix.QuickFix;
import ghidra.features.base.replace.SearchAndReplaceHandler;
import ghidra.features.base.replace.SearchAndReplaceQuery;
import ghidra.features.base.replace.SearchType;
import ghidra.features.base.replace.items.UpdateCommentQuickFix;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnitComments;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ListingCommentsSearchAndReplaceHandler
extends SearchAndReplaceHandler {
    public ListingCommentsSearchAndReplaceHandler() {
        this.addType(new SearchType(this, "Comments", "Search and replace in listing comments"));
    }

    @Override
    public void findAll(Program program, SearchAndReplaceQuery query, Accumulator<QuickFix> accumulator, TaskMonitor monitor) throws CancelledException {
        Listing listing = program.getListing();
        long count = listing.getCommentAddressCount();
        monitor.initialize(count, "Searching Comments...");
        Pattern pattern = query.getSearchPattern();
        String replaceMentText = query.getReplacementText();
        for (Address address : listing.getCommentAddressIterator((AddressSetView)program.getMemory(), true)) {
            monitor.checkCancelled();
            CodeUnitComments comments = listing.getAllComments(address);
            for (CommentType type : CommentType.values()) {
                String comment = comments.getComment(type);
                String newComment = this.checkMatch(pattern, comment, replaceMentText);
                if (newComment == null) continue;
                accumulator.add((Object)new UpdateCommentQuickFix(program, address, type, comment, newComment));
            }
        }
    }

    private String checkMatch(Pattern pattern, String comment, String replacementText) {
        if (comment == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(comment);
        if (matcher.find()) {
            return matcher.replaceAll(replacementText);
        }
        return null;
    }
}

