/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import db.DBHandle;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.LoadException;
import ghidra.app.util.opinion.LoadResults;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderTier;
import ghidra.framework.Application;
import ghidra.framework.data.OpenMode;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.store.db.PackedDatabase;
import ghidra.framework.store.local.ItemSerializer;
import ghidra.program.database.ProgramDB;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import utilities.util.FileUtilities;

public class GzfLoader
implements Loader {
    public static final String GZF_NAME = "GZF Input Format";

    @Override
    public LoaderTier getTier() {
        return LoaderTier.SPECIALIZED_TARGET_LOADER;
    }

    @Override
    public int getTierPriority() {
        return 0;
    }

    @Override
    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        if (options != null && options.size() > 0) {
            return "GzfLoader takes no options";
        }
        return null;
    }

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        return Collections.emptyList();
    }

    @Override
    public LoadResults<? extends DomainObject> load(ByteProvider provider, String programName, Project project, String projectFolderPath, LoadSpec loadSpec, List<Option> options, MessageLog messageLog, Object consumer, TaskMonitor monitor) throws IOException, CancelledException, VersionException {
        Program program = this.loadPackedProgramDatabase(provider, programName, consumer, monitor);
        return new LoadResults<Program>(program, programName, projectFolderPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Program loadPackedProgramDatabase(ByteProvider provider, String programName, Object consumer, TaskMonitor monitor) throws IOException, CancelledException, VersionException, LanguageNotFoundException {
        File file = provider.getFile();
        File tmpFile = null;
        if (file == null) {
            file = tmpFile = GzfLoader.createTmpFile(provider, monitor);
        }
        try {
            ProgramDB program;
            PackedDatabase packedDatabase = PackedDatabase.getPackedDatabase((File)file, (boolean)true, (TaskMonitor)monitor);
            boolean success = false;
            DBHandle dbh = null;
            try {
                if (!"Program".equals(packedDatabase.getContentType())) {
                    throw new IOException("File imported is not a Program: " + programName);
                }
                monitor.setMessage("Restoring " + provider.getName());
                dbh = packedDatabase.open(monitor);
                program = new ProgramDB(dbh, OpenMode.UPGRADE, monitor, consumer);
                success = true;
            }
            finally {
                if (!success) {
                    if (dbh != null) {
                        dbh.close();
                    } else {
                        packedDatabase.dispose();
                    }
                }
            }
            ProgramDB programDB = program;
            return programDB;
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    @Override
    public void loadInto(ByteProvider provider, LoadSpec loadSpec, List<Option> options, MessageLog messageLog, Program program, TaskMonitor monitor) throws IOException, LoadException, CancelledException {
        throw new LoadException("Cannot add GZF to program");
    }

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (GzfLoader.isGzfFile(provider)) {
            loadSpecs.add(new LoadSpec((Loader)this, 0L, false));
        }
        return loadSpecs;
    }

    @Override
    public String getPreferredFileName(ByteProvider provider) {
        return FilenameUtils.removeExtension((String)provider.getName());
    }

    private static File createTmpFile(ByteProvider provider, TaskMonitor monitor) throws IOException {
        File tmpFile = Application.createTempFile((String)"ghidra_gzf_loader", null);
        try (InputStream is = provider.getInputStream(0L);
             FileOutputStream fos = new FileOutputStream(tmpFile);){
            FileUtilities.copyStreamToStream((InputStream)is, (OutputStream)fos, (TaskMonitor)monitor);
        }
        return tmpFile;
    }

    private static boolean isGzfFile(ByteProvider provider) {
        if (!provider.getName().toLowerCase().endsWith(".gzf")) {
            return false;
        }
        boolean isGZF = false;
        try (InputStream inputStream = provider.getInputStream(0L);){
            isGZF = ItemSerializer.isPackedFile((InputStream)inputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isGZF;
    }

    @Override
    public String getName() {
        return GZF_NAME;
    }
}

