/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfIndex;
import ghidra.app.util.bin.format.omf.OmfUtils;
import ghidra.app.util.bin.format.omf.omf.OmfExternalSymbol;
import ghidra.app.util.bin.format.omf.omf.OmfRecordTypes;
import ghidra.app.util.bin.format.omf.omf.OmfSymbol;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OmfComdatExternalSymbol
extends OmfExternalSymbol {
    protected List<ExternalLookup> externalLookups = new ArrayList<ExternalLookup>();
    private List<Reference> refs = new ArrayList<Reference>();

    public OmfComdatExternalSymbol(BinaryReader reader) throws IOException {
        super(reader, false);
    }

    @Override
    public void parseData() throws IOException, OmfException {
        while (this.dataReader.getPointerIndex() < this.dataEnd) {
            OmfIndex nameIndex = OmfUtils.readIndex(this.dataReader);
            OmfIndex type = OmfUtils.readIndex(this.dataReader);
            this.refs.add(new Reference(nameIndex, type));
            this.externalLookups.add(new ExternalLookup(nameIndex.value(), type.value()));
        }
    }

    public void loadNames(List<String> nameList) {
        for (ExternalLookup ext : this.externalLookups) {
            String name = nameList.get(ext.nameIndex - 1);
            this.symbols.add(new OmfSymbol(name, ext.type, 0L, 0, 0));
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(OmfRecordTypes.getName(this.recordType), 0);
        struct.add(BYTE, "type", null);
        struct.add(WORD, "length", null);
        for (Reference ref : this.refs) {
            struct.add(ref.nameIndex.toDataType(), "logical_name_index", null);
            struct.add(ref.typeIndex.toDataType(), "type_index", null);
        }
        struct.add(BYTE, "checksum", null);
        struct.setCategoryPath(new CategoryPath("/OMF"));
        return struct;
    }

    private record Reference(OmfIndex nameIndex, OmfIndex typeIndex) {
    }

    public record ExternalLookup(int nameIndex, int type) {
    }
}

