/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff.archive;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.coff.CoffException;
import ghidra.app.util.bin.format.coff.archive.CoffArchiveConstants;
import ghidra.app.util.bin.format.coff.archive.CoffArchiveMemberHeader;
import ghidra.app.util.bin.format.coff.archive.FirstLinkerMember;
import ghidra.app.util.bin.format.coff.archive.LongNamesMember;
import ghidra.app.util.bin.format.coff.archive.SecondLinkerMember;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class CoffArchiveHeader
implements StructConverter {
    private FirstLinkerMember _firstLinkerMember;
    private SecondLinkerMember _secondLinkerMember;
    private LongNamesMember _longNameMember;
    private List<CoffArchiveMemberHeader> _memberHeaders = new ArrayList<CoffArchiveMemberHeader>();
    private boolean isMS = false;

    public static boolean isMatch(ByteProvider provider) throws IOException {
        return provider.length() > (long)CoffArchiveConstants.MAGIC_LEN && "!<arch>\n".equals(new String(provider.readBytes(0L, CoffArchiveConstants.MAGIC_LEN)));
    }

    public static CoffArchiveHeader read(ByteProvider provider, TaskMonitor monitor) throws CoffException, IOException {
        if (!CoffArchiveHeader.isMatch(provider)) {
            return null;
        }
        BinaryReader reader = new BinaryReader(provider, false);
        reader.setPointerIndex(CoffArchiveConstants.MAGIC_LEN);
        int memberNum = 0;
        CoffArchiveHeader cah = new CoffArchiveHeader();
        long eofPos = reader.length() - 60L;
        while (reader.getPointerIndex() < eofPos && !monitor.isCancelled()) {
            try {
                CoffArchiveMemberHeader camh;
                block13: {
                    block12: {
                        camh = CoffArchiveMemberHeader.read(reader, cah._longNameMember);
                        if (!camh.getName().equals("/")) break block12;
                        switch (memberNum) {
                            case 0: {
                                cah._firstLinkerMember = new FirstLinkerMember(reader, camh, true);
                                break block13;
                            }
                            case 1: {
                                cah._secondLinkerMember = new SecondLinkerMember(reader, camh, true);
                                break block13;
                            }
                            default: {
                                throw new CoffException("Invalid COFF: multiple 1st and 2nd linker members detected.");
                            }
                        }
                    }
                    if (camh.getName().equals("//")) {
                        if (cah._longNameMember == null) {
                            cah._longNameMember = new LongNamesMember(reader, camh);
                        } else {
                            throw new CoffException("Invalid COFF: multiple long name members detected.");
                        }
                    }
                }
                cah._memberHeaders.add(camh);
                ++memberNum;
                reader.setPointerIndex(camh.getPayloadOffset() + camh.getSize());
            }
            catch (IOException e) {
                if (memberNum <= 3) {
                    throw e;
                }
                Msg.warn(CoffArchiveMemberHeader.class, (Object)("Problem reading COFF archive headers in " + String.valueOf(provider.getFSRL()) + ", only " + memberNum + " members found."), (Throwable)e);
                break;
            }
        }
        cah.isMS = cah._firstLinkerMember != null && cah._secondLinkerMember != null && cah._longNameMember != null;
        return cah;
    }

    protected CoffArchiveHeader() {
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(StructConverterUtil.parseName(CoffArchiveHeader.class), 0);
        struct.add(STRING, CoffArchiveConstants.MAGIC_LEN, "magic", null);
        return struct;
    }

    public List<CoffArchiveMemberHeader> getArchiveMemberHeaders() {
        return this._memberHeaders;
    }

    public FirstLinkerMember getFirstLinkerMember() {
        return this._firstLinkerMember;
    }

    public SecondLinkerMember getSecondLinkerMember() {
        return this._secondLinkerMember;
    }

    public LongNamesMember getLongNameMember() {
        return this._longNameMember;
    }

    public boolean isMSFormat() {
        return this.isMS;
    }
}

