/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.validator;

import docking.widgets.conditiontestpanel.ConditionResult;
import docking.widgets.conditiontestpanel.ConditionStatus;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.validator.VTPreconditionValidator;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;

public class NoReturnsFunctionsValidator
extends VTPreconditionValidator {
    private static final String NAME = "Number Of No-Returns Functions Validator";
    public static final String DIFFERENCE_THRESHOLD = "Maximum percentage difference between number of no-return functions in each program";
    public static final float DIFFERENCE_THRESHOLD_DEFAULT = 0.0f;

    public NoReturnsFunctionsValidator(Program sourceProgram, Program destinationProgram, VTSession existingResults) {
        super(sourceProgram, destinationProgram, existingResults);
    }

    @Override
    public ConditionResult doRun(TaskMonitor monitor) {
        int max;
        int diff;
        float percent;
        float threshold = 0.0f;
        int numSource = this.checkNumNoReturnFunctions(this.sourceProgram, monitor);
        int numDest = this.checkNumNoReturnFunctions(this.destinationProgram, monitor);
        ConditionStatus status = ConditionStatus.Passed;
        StringBuilder warnings = new StringBuilder();
        if (!monitor.isCancelled() && (percent = (float)(diff = Math.abs(numSource - numDest)) / (float)(max = Math.max(numSource, numDest))) > threshold) {
            status = ConditionStatus.Warning;
            warnings.append(this.sourceProgram.getDomainFile().getName() + " and " + this.destinationProgram.getDomainFile().getName() + " have " + numSource + " and " + numDest + " no-return functions respectively,\n");
            warnings.append("which is a " + NoReturnsFunctionsValidator.format(percent) + " percent difference, greater than the threshold of " + NoReturnsFunctionsValidator.format(threshold) + "\n");
        }
        return new ConditionResult(status, warnings.toString());
    }

    private static String format(float percent) {
        return String.format("%.1f%%", (double)percent * 100.0);
    }

    private int checkNumNoReturnFunctions(Program prog, TaskMonitor monitor) {
        FunctionIterator funcIter = prog.getFunctionManager().getFunctions(true);
        int numNoReturnFuncs = 0;
        monitor.setIndeterminate(true);
        while (funcIter.hasNext() && !monitor.isCancelled()) {
            monitor.incrementProgress(1L);
            Function func = (Function)funcIter.next();
            Address address = func.getEntryPoint();
            Instruction inst = prog.getListing().getInstructionAt(address);
            if (inst == null || !func.hasNoReturn()) continue;
            ++numNoReturnFuncs;
        }
        return numNoReturnFuncs;
    }

    public String getDescription() {
        return "Makes sure the two programs have nearly the same number of no-return functions.";
    }

    public String getName() {
        return NAME;
    }
}

