/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.target.schema;

import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.iface.TraceObjectInterface;
import ghidra.trace.model.target.info.TraceObjectInterfaceFactory;
import ghidra.trace.model.target.info.TraceObjectInterfaceUtils;
import ghidra.trace.model.target.schema.DefaultSchemaContext;
import ghidra.trace.model.target.schema.DefaultTraceObjectSchema;
import ghidra.trace.model.target.schema.PrimitiveTraceObjectSchema;
import ghidra.trace.model.target.schema.SchemaBuilder;
import ghidra.trace.model.target.schema.SchemaContext;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import ghidra.util.Msg;
import ghidra.util.xml.XmlUtilities;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class XmlSchemaContext
extends DefaultSchemaContext {
    protected static final String ELEM_CONTEXT = "context";
    protected static final String ATTR_CANONICAL = "canonical";
    protected static final String ELEM_SCHEMA = "schema";
    protected static final String ELEM_INTERFACE = "interface";
    protected static final String ELEM_ELEMENT = "element";
    protected static final String ATTR_INDEX = "index";
    protected static final String ELEM_ATTRIBUTE = "attribute";
    protected static final String ATTR_NAME = "name";
    protected static final String ATTR_SCHEMA = "schema";
    protected static final String ATTR_REQUIRED = "required";
    protected static final String ATTR_FIXED = "fixed";
    protected static final String ATTR_HIDDEN = "hidden";
    protected static final String ELEM_ATTRIBUTE_ALIAS = "attribute-alias";
    protected static final String ATTR_FROM = "from";
    protected static final String ATTR_TO = "to";
    protected static final String YES = "yes";
    protected static final String NO = "no";
    protected static final String DEFAULT = "default";
    protected static final Set<String> TRUES = Set.of("true", "yes", "y", "1");
    protected static final Set<String> FALSES = Set.of("false", "no", "n", "0");
    protected final Map<String, TraceObjectSchema.SchemaName> names = new HashMap<String, TraceObjectSchema.SchemaName>();

    protected static boolean parseBoolean(Element ele, String attrName) {
        return TRUES.contains(ele.getAttributeValue(attrName, NO).toLowerCase());
    }

    protected static TraceObjectSchema.Hidden parseHidden(Element ele, String attrName) {
        String value = ele.getAttributeValue(attrName, DEFAULT).toLowerCase();
        if (TRUES.contains(value)) {
            return TraceObjectSchema.Hidden.TRUE;
        }
        if (FALSES.contains(value)) {
            return TraceObjectSchema.Hidden.FALSE;
        }
        return TraceObjectSchema.Hidden.DEFAULT;
    }

    public static String serialize(SchemaContext ctx) {
        return XmlUtilities.toString((Element)XmlSchemaContext.contextToXml(ctx));
    }

    public static Element contextToXml(SchemaContext ctx) {
        Element result = new Element(ELEM_CONTEXT);
        for (TraceObjectSchema schema : ctx.getAllSchemas()) {
            Element schemaElem = XmlSchemaContext.schemaToXml(schema);
            if (schemaElem == null) continue;
            result.addContent((Content)schemaElem);
        }
        return result;
    }

    public static Element attributeSchemaToXml(TraceObjectSchema.AttributeSchema as) {
        Element attrElem = new Element(ELEM_ATTRIBUTE);
        if (!as.getName().isEmpty()) {
            XmlUtilities.setStringAttr((Element)attrElem, (String)ATTR_NAME, (String)as.getName());
        }
        XmlUtilities.setStringAttr((Element)attrElem, (String)"schema", (String)as.getSchema().toString());
        if (as.isRequired()) {
            XmlUtilities.setStringAttr((Element)attrElem, (String)ATTR_REQUIRED, (String)YES);
        }
        if (as.isFixed()) {
            XmlUtilities.setStringAttr((Element)attrElem, (String)ATTR_FIXED, (String)YES);
        }
        switch (as.getHidden()) {
            case TRUE: {
                XmlUtilities.setStringAttr((Element)attrElem, (String)ATTR_HIDDEN, (String)YES);
                break;
            }
            case FALSE: {
                if (!as.getName().isEmpty()) break;
                XmlUtilities.setStringAttr((Element)attrElem, (String)ATTR_HIDDEN, (String)NO);
                break;
            }
        }
        return attrElem;
    }

    public static Element aliasToXml(Map.Entry<String, String> alias) {
        Element aliasElem = new Element(ELEM_ATTRIBUTE_ALIAS);
        XmlUtilities.setStringAttr((Element)aliasElem, (String)ATTR_FROM, (String)alias.getKey());
        XmlUtilities.setStringAttr((Element)aliasElem, (String)ATTR_TO, (String)alias.getValue());
        return aliasElem;
    }

    public static Element schemaToXml(TraceObjectSchema schema) {
        if (!TraceObject.class.isAssignableFrom(schema.getType())) {
            return null;
        }
        if (schema == PrimitiveTraceObjectSchema.OBJECT) {
            return null;
        }
        Element result = new Element("schema");
        XmlUtilities.setStringAttr((Element)result, (String)ATTR_NAME, (String)schema.getName().toString());
        for (Class<? extends TraceObjectInterface> clazz : schema.getInterfaces()) {
            Element element = new Element(ELEM_INTERFACE);
            XmlUtilities.setStringAttr((Element)element, (String)ATTR_NAME, (String)TraceObjectInterfaceUtils.getSchemaName(clazz));
            result.addContent((Content)element);
        }
        if (schema.isCanonicalContainer()) {
            XmlUtilities.setStringAttr((Element)result, (String)ATTR_CANONICAL, (String)YES);
        }
        for (Map.Entry entry : schema.getElementSchemas().entrySet()) {
            Element element = new Element(ELEM_ELEMENT);
            XmlUtilities.setStringAttr((Element)element, (String)ATTR_INDEX, (String)((String)entry.getKey()));
            XmlUtilities.setStringAttr((Element)element, (String)"schema", (String)((TraceObjectSchema.SchemaName)entry.getValue()).toString());
            result.addContent((Content)element);
        }
        TraceObjectSchema.SchemaName des = schema.getDefaultElementSchema();
        if (!Objects.equals(des, SchemaBuilder.DEFAULT_ELEMENT_SCHEMA)) {
            Element element = new Element(ELEM_ELEMENT);
            XmlUtilities.setStringAttr((Element)element, (String)"schema", (String)des.toString());
            result.addContent((Content)element);
        }
        for (Map.Entry<String, TraceObjectSchema.AttributeSchema> entry : schema.getAttributeSchemas().entrySet()) {
            TraceObjectSchema.AttributeSchema as = entry.getValue();
            if (!entry.getKey().equals(as.getName())) continue;
            Element attrElem = XmlSchemaContext.attributeSchemaToXml(as);
            result.addContent((Content)attrElem);
        }
        TraceObjectSchema.AttributeSchema attributeSchema = schema.getDefaultAttributeSchema();
        if (!Objects.equals(attributeSchema, SchemaBuilder.DEFAULT_ATTRIBUTE_SCHEMA)) {
            Element element = XmlSchemaContext.attributeSchemaToXml(attributeSchema);
            result.addContent((Content)element);
        }
        for (Map.Entry<String, String> alias : schema.getAttributeAliases().entrySet()) {
            Element aliasElem = XmlSchemaContext.aliasToXml(alias);
            result.addContent((Content)aliasElem);
        }
        return result;
    }

    public static XmlSchemaContext deserialize(String xml) throws JDOMException {
        return XmlSchemaContext.deserialize(xml.getBytes());
    }

    public static XmlSchemaContext deserialize(byte[] xml) throws JDOMException {
        try {
            return XmlSchemaContext.deserialize(new ByteArrayInputStream(xml));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static XmlSchemaContext deserialize(File file) throws JDOMException, IOException {
        return XmlSchemaContext.deserialize(new FileInputStream(file));
    }

    public static XmlSchemaContext deserialize(InputStream is) throws JDOMException, IOException {
        SAXBuilder sb = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
        Document doc = sb.build(Objects.requireNonNull(is));
        return XmlSchemaContext.contextFromXml(doc.getRootElement());
    }

    public static XmlSchemaContext contextFromXml(Element contextElem) {
        XmlSchemaContext ctx = new XmlSchemaContext();
        for (Element schemaElem : XmlUtilities.getChildren((Element)contextElem, (String)"schema")) {
            ctx.schemaFromXml(schemaElem);
        }
        return ctx;
    }

    public synchronized TraceObjectSchema.SchemaName name(String name) {
        return this.names.computeIfAbsent(name, TraceObjectSchema.SchemaName::new);
    }

    private String requireAttributeValue(Element elem, String name) {
        String value = elem.getAttributeValue(name);
        if (value == null) {
            throw new IllegalArgumentException("Missing attribute '%s' in %s".formatted(name, elem));
        }
        return value;
    }

    public TraceObjectSchema schemaFromXml(Element schemaElem) {
        TraceObjectSchema.SchemaName schema;
        SchemaBuilder builder = this.builder(this.name(schemaElem.getAttributeValue(ATTR_NAME, "")));
        Map<String, TraceObjectInterfaceFactory.Constructor<?>> ctors = TraceObjectInterfaceUtils.getConstructorsByName();
        for (Element ifaceElem : XmlUtilities.getChildren((Element)schemaElem, (String)ELEM_INTERFACE)) {
            String ifaceName = this.requireAttributeValue(ifaceElem, ATTR_NAME);
            TraceObjectInterfaceFactory.Constructor<?> c = ctors.get(ifaceName);
            if (c == null) {
                Msg.warn((Object)this, (Object)("Unknown interface name: '" + ifaceName + "'"));
                continue;
            }
            builder.addInterface(c.iface());
        }
        builder.setCanonicalContainer(XmlSchemaContext.parseBoolean(schemaElem, ATTR_CANONICAL));
        for (Element elemElem : XmlUtilities.getChildren((Element)schemaElem, (String)ELEM_ELEMENT)) {
            schema = this.name(this.requireAttributeValue(elemElem, "schema"));
            String index = elemElem.getAttributeValue(ATTR_INDEX, "");
            builder.addElementSchema(index, schema, elemElem);
        }
        for (Element attrElem : XmlUtilities.getChildren((Element)schemaElem, (String)ELEM_ATTRIBUTE)) {
            schema = this.name(this.requireAttributeValue(attrElem, "schema"));
            boolean required = XmlSchemaContext.parseBoolean(attrElem, ATTR_REQUIRED);
            boolean fixed = XmlSchemaContext.parseBoolean(attrElem, ATTR_FIXED);
            TraceObjectSchema.Hidden hidden = XmlSchemaContext.parseHidden(attrElem, ATTR_HIDDEN);
            String name = attrElem.getAttributeValue(ATTR_NAME, "");
            builder.addAttributeSchema(new DefaultTraceObjectSchema.DefaultAttributeSchema(name, schema, required, fixed, hidden), attrElem);
        }
        for (Element aliasElem : XmlUtilities.getChildren((Element)schemaElem, (String)ELEM_ATTRIBUTE_ALIAS)) {
            String from = this.requireAttributeValue(aliasElem, ATTR_FROM);
            String to = this.requireAttributeValue(aliasElem, ATTR_TO);
            builder.addAttributeAlias(from, to, aliasElem);
        }
        return builder.buildAndAdd();
    }
}

