/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.MathUtilities;
import java.nio.ByteBuffer;

public abstract class ByteCache {
    public static final int BITS = 12;
    public static final long OFFSET_MASK = -4096L;
    public static final int SIZE = 4096;
    private final int pageCount;
    private final Page[] pages;

    public ByteCache(int pageCount) {
        this.pageCount = pageCount;
        this.pages = new Page[pageCount];
        for (int i = 0; i < pageCount; ++i) {
            this.pages[i] = this.newPage();
        }
    }

    protected Page newPage() {
        return new Page();
    }

    public boolean canCache(Address address, int len) {
        long cacheBufOff = address.getOffset() & 0xFFFL;
        return cacheBufOff + (long)len < (long)(this.pageCount * 4096);
    }

    public byte read(Address address) throws MemoryAccessException {
        Address pageStart = address.getNewAddress(address.getOffset() & 0xFFFFFFFFFFFFF000L);
        Page page = this.ensurePageCached(pageStart, 1);
        int cacheBufOff = (int)address.subtract(pageStart);
        return page.bytes[cacheBufOff];
    }

    public int read(Address address, ByteBuffer buf) throws MemoryAccessException {
        long startOff = address.getOffset();
        long startPage = startOff & 0xFFFFFFFFFFFFF000L;
        int bufStart = buf.position();
        long memOffset = startPage;
        int cacheBufOff = (int)(startOff - startPage);
        while (buf.hasRemaining()) {
            int required = MathUtilities.unsignedMin((int)(4096 - cacheBufOff), (int)buf.remaining());
            Page page = this.ensurePageCached(address.getNewAddress(memOffset), required);
            buf.put(page.bytes, cacheBufOff, required);
            memOffset += 4096L;
            cacheBufOff = 0;
        }
        return buf.position() - bufStart;
    }

    protected int choosePage(Address address, int len) {
        for (int i = 0; i < this.pageCount; ++i) {
            Page page = this.pages[i];
            if (!page.contains(address, len)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page ensurePageCached(Address address, int len) throws MemoryAccessException {
        int chosen = this.choosePage(address, len);
        if (chosen == -1) {
            this.pages[this.pageCount - 1].load(address, len);
            chosen = this.pageCount - 1;
        }
        if (chosen == 0) {
            return this.pages[0];
        }
        Page[] pageArray = this.pages;
        synchronized (this.pages) {
            Page temp = this.pages[chosen];
            this.pages[chosen] = this.pages[0];
            this.pages[0] = temp;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return temp;
        }
    }

    protected abstract int doLoad(Address var1, ByteBuffer var2) throws MemoryAccessException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(AddressRange range) {
        Page[] pageArray = this.pages;
        synchronized (this.pages) {
            for (Page p : this.pages) {
                p.invalidate(range);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private class Page {
        private volatile boolean valid = false;
        private Address start = null;
        private final byte[] bytes = new byte[4096];
        private final ByteBuffer buf = ByteBuffer.wrap(this.bytes);
        private int len;

        private Page() {
        }

        public final boolean contains(Address address, int length) {
            if (!this.valid || this.start == null) {
                return false;
            }
            if (this.start.getAddressSpace() != address.getAddressSpace()) {
                return false;
            }
            long offset = address.subtract(this.start);
            return Long.compareUnsigned(offset + (long)length, this.len) < 0;
        }

        public final int load(Address address, int length) throws MemoryAccessException {
            this.valid = false;
            this.start = address.getNewAddress(address.getOffset() & 0xFFFFFFFFFFFFF000L);
            long offset = address.subtract(this.start);
            this.buf.clear();
            this.len = ByteCache.this.doLoad(address, this.buf);
            if ((long)this.len < offset + (long)length) {
                throw new MemoryAccessException();
            }
            this.valid = true;
            return (int)offset;
        }

        public void invalidate(AddressRange range) {
            this.valid = false;
        }
    }
}

