/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.BooleanArray;
import ghidra.util.datastruct.DataTable;

public class ManagedDataTable
extends DataTable {
    private static final long serialVersionUID = 1L;
    private BooleanArray occupied = new BooleanArray();
    private int maxRow;

    public boolean hasRow(int row) {
        if (row < 0) {
            return false;
        }
        return this.occupied.get(row);
    }

    public int getMaxRow() {
        return this.maxRow;
    }

    @Override
    public void removeRow(int row) {
        if (this.occupied.get(row)) {
            super.removeRow(row);
            this.occupied.remove(row);
            if (row == this.maxRow) {
                this.maxRow = 0;
                for (int i = row; i >= 0; --i) {
                    if (!this.occupied.get(i)) continue;
                    this.maxRow = i;
                    break;
                }
            }
        }
    }

    @Override
    public void putBoolean(int row, int col, boolean value) {
        this.maxRow = Math.max(this.maxRow, row);
        this.occupied.put(row, true);
        super.putBoolean(row, col, value);
    }

    @Override
    public void putByte(int row, int col, byte value) {
        this.maxRow = Math.max(this.maxRow, row);
        this.occupied.put(row, true);
        super.putByte(row, col, value);
    }

    @Override
    public void putShort(int row, int col, short value) {
        this.maxRow = Math.max(this.maxRow, row);
        this.occupied.put(row, true);
        super.putShort(row, col, value);
    }

    @Override
    public void putInt(int row, int col, int value) {
        this.maxRow = Math.max(this.maxRow, row);
        this.occupied.put(row, true);
        super.putInt(row, col, value);
    }

    @Override
    public void putLong(int row, int col, long value) {
        this.maxRow = Math.max(this.maxRow, row);
        this.occupied.put(row, true);
        super.putLong(row, col, value);
    }

    @Override
    public void putDouble(int row, int col, double value) {
        this.maxRow = Math.max(this.maxRow, row);
        this.occupied.put(row, true);
        super.putDouble(row, col, value);
    }

    @Override
    public void putFloat(int row, int col, float value) {
        this.maxRow = Math.max(this.maxRow, row);
        this.occupied.put(row, true);
        super.putFloat(row, col, value);
    }

    @Override
    public void putString(int row, int col, String value) {
        this.maxRow = Math.max(this.maxRow, row);
        this.occupied.put(row, true);
        super.putString(row, col, value);
    }

    @Override
    public void putByteArray(int row, int col, byte[] value) {
        this.maxRow = Math.max(this.maxRow, row);
        this.occupied.put(row, true);
        super.putByteArray(row, col, value);
    }

    @Override
    public void putShortArray(int row, int col, short[] value) {
        this.maxRow = Math.max(this.maxRow, row);
        this.occupied.put(row, true);
        super.putShortArray(row, col, value);
    }

    @Override
    public void putIntArray(int row, int col, int[] value) {
        this.maxRow = Math.max(this.maxRow, row);
        this.occupied.put(row, true);
        super.putIntArray(row, col, value);
    }

    @Override
    public void putFloatArray(int row, int col, float[] value) {
        this.maxRow = Math.max(this.maxRow, row);
        this.occupied.put(row, true);
        super.putFloatArray(row, col, value);
    }

    @Override
    public void putDoubleArray(int row, int col, double[] value) {
        this.maxRow = Math.max(this.maxRow, row);
        this.occupied.put(row, true);
        super.putDoubleArray(row, col, value);
    }

    @Override
    public void putLongArray(int row, int col, long[] value) {
        this.maxRow = Math.max(this.maxRow, row);
        this.occupied.put(row, true);
        super.putLongArray(row, col, value);
    }
}

