/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.ObjectStorage;
import ghidra.util.Saveable;
import java.io.Serializable;

public class IntArrayList
implements Serializable,
Saveable {
    private static final long serialVersionUID = 1L;
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final int MIN_SIZE = 4;
    int[] ints;
    int size = 0;
    private Class<?>[] classes = new Class[]{Integer[].class};

    public IntArrayList() {
        this.ints = new int[4];
    }

    public IntArrayList(boolean useZeroSize) {
        this.ints = useZeroSize ? EMPTY_INT_ARRAY : new int[4];
    }

    public IntArrayList(int[] arr) {
        this.ints = arr;
        this.size = arr.length;
    }

    public void add(int value) {
        this.add(this.size, value);
    }

    public void add(int index, int value) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (this.size == this.ints.length) {
            this.growArray();
        }
        System.arraycopy(this.ints, index, this.ints, index + 1, this.size - index);
        this.ints[index] = value;
        ++this.size;
    }

    public void removeValueAt(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.ints, index + 1, this.ints, index, this.size - index - 1);
        --this.size;
        if (this.size < this.ints.length / 4) {
            this.shrinkArray();
        }
    }

    public void removeValue(int value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.ints[i] != value) continue;
            this.removeValueAt(i);
            return;
        }
    }

    public int get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.ints[index];
    }

    public void set(int index, int value) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.ints[index] = value;
    }

    public void clear() {
        this.size = 0;
        this.ints = new int[4];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int[] toArray() {
        int[] tmparr = new int[this.size];
        System.arraycopy(this.ints, 0, tmparr, 0, this.size);
        return tmparr;
    }

    private void growArray() {
        int[] newints = new int[Math.max(this.ints.length * 2, 4)];
        System.arraycopy(this.ints, 0, newints, 0, this.ints.length);
        this.ints = newints;
    }

    private void shrinkArray() {
        int newsize = this.ints.length / 2;
        if (newsize < 4) {
            return;
        }
        int[] newints = new int[newsize];
        System.arraycopy(this.ints, 0, newints, 0, this.size);
        this.ints = newints;
    }

    @Override
    public void restore(ObjectStorage objStorage) {
        this.ints = objStorage.getInts();
        this.size = this.ints.length;
    }

    @Override
    public void save(ObjectStorage objStorage) {
        objStorage.putInts(this.toArray());
    }

    @Override
    public Class<?>[] getObjectStorageFields() {
        return this.classes;
    }

    @Override
    public int getSchemaVersion() {
        return 0;
    }

    @Override
    public boolean isUpgradeable(int oldSchemaVersion) {
        return false;
    }

    @Override
    public boolean upgrade(ObjectStorage oldObjStorage, int oldSchemaVersion, ObjectStorage currentObjStorage) {
        return false;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }
}

