/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.util;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import org.jgrapht.Graph;
import org.jungrapht.visualization.DefaultVisualizationServer;
import org.jungrapht.visualization.VisualizationImageServer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.layout.algorithms.StaticLayoutAlgorithm;
import org.jungrapht.visualization.renderers.BiModalRenderer;

public class GraphImage {
    public static <V, E> void capture(VisualizationViewer<V, E> vv) {
        File outputFile;
        JFileChooser fileChooser = new JFileChooser();
        int returnValue = fileChooser.showOpenDialog(vv.getComponent());
        if (returnValue == 0 && (outputFile = fileChooser.getSelectedFile()) != null) {
            Graph graph = vv.getVisualizationModel().getGraph();
            Dimension vvLayoutSize = vv.getVisualizationModel().getLayoutSize();
            DefaultVisualizationServer vis = ((VisualizationImageServer.Builder)((VisualizationImageServer.Builder)((VisualizationImageServer.Builder)VisualizationImageServer.builder(graph).viewSize(vvLayoutSize)).layoutSize(vvLayoutSize)).layoutAlgorithm(new StaticLayoutAlgorithm())).build();
            ((VisualizationImageServer)vis).setRenderContext(vv.getRenderContext());
            ((VisualizationImageServer)vis).getVisualizationModel().getLayoutModel().setInitializer(vv.getVisualizationModel().getLayoutModel());
            ((VisualizationImageServer)vis).getRenderer().setMode(BiModalRenderer.HEAVYWEIGHT);
            Image image = ((VisualizationImageServer)vis).getFullImage();
            try {
                ImageIO.write((RenderedImage)((BufferedImage)image), "jpg", outputFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

