/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import generic.concurrent.ConcurrentQ;
import generic.concurrent.ConcurrentQBuilder;
import generic.concurrent.GThreadPool;
import generic.concurrent.QCallback;
import generic.concurrent.QResult;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.cmd.function.DecompilerSwitchAnalysisCmd;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.decompiler.parallel.DecompileConfigurer;
import ghidra.app.decompiler.parallel.DecompilerCallback;
import ghidra.app.decompiler.parallel.ParallelDecompiler;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.SwitchAnalysisDecompileConfigurer;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.Analyzer;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.block.SimpleBlockModel;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.PcodeInjectLibrary;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.ContextEvaluatorAdapter;
import ghidra.program.util.SymbolicPropogator;
import ghidra.program.util.VarnodeContext;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;

public class DecompilerSwitchAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Decompiler Switch Analysis";
    private static final String DESCRIPTION = "Creates switch statements for dynamic instructions using Decompiler.";
    private static final String OPTION_NAME_DECOMPILER_TIMEOUT_SECS = "Analysis Decompiler Timeout (sec)";
    private static final String OPTION_DESCRIPTION_DECOMPILER_TIMEOUT_SECS = "Set timeout in seconds for analyzer decompiler calls.";
    public static final int OPTION_DEFAULT_DECOMPILER_TIMEOUT_SECS = 60;
    private int decompilerTimeoutSecondsOption = 60;
    private HashMap<Long, InjectPayload> injectPayloadCache = new HashMap();
    private boolean hitNonReturningThunkFunction = false;

    public DecompilerSwitchAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.INSTRUCTION_ANALYZER);
        this.setPriority(AnalysisPriority.CODE_ANALYSIS);
        this.setDefaultEnablement(true);
        this.setSupportsOneTimeAnalysis();
    }

    public boolean canAnalyze(Program program) {
        return program.getLanguage().supportsPcode();
    }

    public boolean getDefaultEnablement(Program program) {
        return true;
    }

    public void registerOptions(Options options, Program program) {
        options.registerOption(OPTION_NAME_DECOMPILER_TIMEOUT_SECS, (Object)this.decompilerTimeoutSecondsOption, null, OPTION_DESCRIPTION_DECOMPILER_TIMEOUT_SECS);
    }

    public void optionsChanged(Options options, Program program) {
        this.decompilerTimeoutSecondsOption = options.getInt(OPTION_NAME_DECOMPILER_TIMEOUT_SECS, this.decompilerTimeoutSecondsOption);
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        try {
            ArrayList<Address> locations = this.findLocations(program, set, monitor);
            if (locations.isEmpty()) {
                return true;
            }
            HashSet<Function> definedFunctions = new HashSet<Function>();
            HashSet<Function> undefinedFunctions = new HashSet<Function>();
            this.findFunctions(program, locations, definedFunctions, undefinedFunctions, monitor);
            if (this.hitNonReturningThunkFunction) {
                this.hitNonReturningThunkFunction = false;
                this.restartRemainingLater(program, definedFunctions, undefinedFunctions);
                return true;
            }
            monitor.checkCancelled();
            this.runDecompilerAnalysis(program, definedFunctions, monitor);
            monitor.checkCancelled();
            this.runDecompilerAnalysis(program, undefinedFunctions, monitor);
            monitor.checkCancelled();
        }
        catch (CancelledException ce) {
            throw ce;
        }
        catch (InterruptedException ie) {
            if (!monitor.isCancelled()) {
                Msg.error((Object)((Object)this), (Object)"Unexpectedly interrupted while analyzing", (Throwable)ie);
            }
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)"Unexpected exception", (Throwable)e);
        }
        return true;
    }

    private void restartRemainingLater(Program program, Collection<Function> definedFunctions, Collection<Function> undefinedFunctions) {
        AddressSet funcSet = new AddressSet();
        for (Function function : definedFunctions) {
            funcSet.add(function.getBody());
        }
        for (Function function : undefinedFunctions) {
            funcSet.add(function.getBody());
        }
        AutoAnalysisManager.getAnalysisManager((Program)program).scheduleOneTimeAnalysis((Analyzer)new DecompilerSwitchAnalyzer(), (AddressSetView)funcSet);
        Msg.info((Object)((Object)this), (Object)"hit non-returning function, restarting decompiler switch analyzer later");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDecompilerAnalysis(final Program program, Collection<Function> functions, final TaskMonitor monitor) throws InterruptedException, Exception {
        DecompilerCallback<Void> callback = new DecompilerCallback<Void>(this, program, (DecompileConfigurer)new SwitchAnalysisDecompileConfigurer(program)){

            @Override
            public Void process(DecompileResults results, TaskMonitor m) throws Exception {
                DecompilerSwitchAnalysisCmd cmd = new DecompilerSwitchAnalysisCmd(results);
                cmd.applyTo(program, monitor);
                return null;
            }
        };
        callback.setTimeout(this.decompilerTimeoutSecondsOption);
        try {
            ParallelDecompiler.decompileFunctions(callback, functions, monitor);
        }
        finally {
            callback.dispose();
        }
    }

    private void findFunctions(Program program, ArrayList<Address> locations, Collection<Function> definedFunctions, Collection<Function> undefinedFunctions, TaskMonitor monitor) throws InterruptedException, Exception, CancelledException {
        GThreadPool pool = AutoAnalysisManager.getSharedAnalsysThreadPool();
        FindFunctionCallback callback = new FindFunctionCallback(program);
        ConcurrentQ queue = new ConcurrentQBuilder().setCollectResults(true).setThreadPool(pool).setMonitor(monitor).build((QCallback)callback);
        for (Address location : locations) {
            queue.add((Object)location);
        }
        Collection results = queue.waitForResults();
        for (QResult result : results) {
            Function function = (Function)result.getResult();
            if (function == null) continue;
            if (function.isThunk()) {
                if (!function.hasNoReturn()) continue;
                this.hitNonReturningThunkFunction = true;
                continue;
            }
            if (function instanceof UndefinedFunction) {
                undefinedFunctions.add(function);
                continue;
            }
            definedFunctions.add(function);
        }
    }

    private ArrayList<Address> findLocations(Program program, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Finding function locations...");
        long total = set.getNumAddresses();
        monitor.initialize(total);
        Address maxAddress = set.getMaxAddress();
        ArrayList<Address> locations = new ArrayList<Address>();
        Listing list = program.getListing();
        InstructionIterator iterator = list.getInstructions(set, true);
        while (iterator.hasNext()) {
            monitor.checkCancelled();
            Instruction instruction = iterator.next();
            FlowType flowType = instruction.getFlowType();
            if ((!flowType.isJump() || !flowType.isComputed()) && !this.isCallFixup(program, instruction, flowType) || this.hasUnrecoverableCallOther(program, instruction)) continue;
            Address address = instruction.getMinAddress();
            locations.add(address);
            long remaining = maxAddress.getOffset() - address.getOffset() + (long)address.getSize();
            monitor.setProgress(total - remaining);
        }
        return locations;
    }

    private boolean hasUnrecoverableCallOther(Program program, Instruction instr) {
        PcodeOp[] pcode;
        HashSet<Varnode> callOtherOutputs = new HashSet<Varnode>();
        for (PcodeOp op : pcode = instr.getPcode(true)) {
            Varnode[] inputs;
            if (op.getOpcode() == 9) {
                Varnode dest;
                if (this.hasPcodeInject(program, op) || (dest = op.getOutput()) == null) continue;
                callOtherOutputs.add(dest);
                continue;
            }
            if (!callOtherOutputs.isEmpty() && op.getOpcode() == 6) {
                if (!callOtherOutputs.contains(op.getInput(0))) continue;
                return true;
            }
            if (callOtherOutputs.isEmpty()) continue;
            for (Varnode in : inputs = op.getInputs()) {
                Varnode dest;
                if (!callOtherOutputs.contains(in) || (dest = op.getOutput()) == null) continue;
                callOtherOutputs.add(dest);
            }
        }
        return false;
    }

    private boolean hasPcodeInject(Program program, PcodeOp op) {
        long callOtherIndex = op.getInput(0).getOffset();
        InjectPayload payload = this.findPcodeInjection(program, callOtherIndex);
        return payload != null;
    }

    private InjectPayload findPcodeInjection(Program program, long callOtherIndex) {
        InjectPayload payload = this.injectPayloadCache.get(callOtherIndex);
        if (payload != null) {
            return payload;
        }
        if (this.injectPayloadCache.containsKey(callOtherIndex)) {
            return null;
        }
        PcodeInjectLibrary snippetLibrary = program.getCompilerSpec().getPcodeInjectLibrary();
        String opName = program.getLanguage().getUserDefinedOpName((int)callOtherIndex);
        payload = "segment".equals(opName) ? snippetLibrary.getPayload(4, "segment_pcode") : snippetLibrary.getPayload(2, opName);
        this.injectPayloadCache.put(callOtherIndex, payload);
        return payload;
    }

    private boolean isCallFixup(Program program, Instruction instr, FlowType flowType) {
        Reference[] referencesFrom;
        if (!flowType.isCall()) {
            return false;
        }
        for (Reference reference : referencesFrom = instr.getReferencesFrom()) {
            Function func;
            if (!reference.getReferenceType().isCall() || (func = program.getFunctionManager().getFunctionAt(reference.getToAddress())) == null || func.getCallFixup() == null) continue;
            return true;
        }
        return false;
    }

    private class FindFunctionCallback
    implements QCallback<Address, Function> {
        private Program program;

        FindFunctionCallback(Program program) {
            this.program = program;
        }

        public Function process(Address location, TaskMonitor monitor) throws Exception {
            Function fixupFunc;
            Instruction instr;
            Reference[] referencesFrom;
            if (monitor.isCancelled()) {
                return null;
            }
            monitor.incrementProgress(1L);
            for (Reference element : referencesFrom = this.program.getReferenceManager().getReferencesFrom(location)) {
                RefType referenceType = element.getReferenceType();
                if (!referenceType.isComputed()) continue;
                return null;
            }
            if (this.handleSimpleBlock(location, monitor) && ((instr = this.program.getListing().getInstructionAt(location)) == null || !DecompilerSwitchAnalyzer.this.isCallFixup(this.program, instr, instr.getFlowType())) && (fixupFunc = this.program.getFunctionManager().getFunctionContaining(location)) != null) {
                CreateFunctionCmd.fixupFunctionBody((Program)this.program, (Function)fixupFunc, (TaskMonitor)monitor);
                if (fixupFunc.hasNoReturn()) {
                    return fixupFunc;
                }
                return null;
            }
            Function func = this.program.getFunctionManager().getFunctionContaining(location);
            if (func == null) {
                func = UndefinedFunction.findFunctionUsingSimpleBlockModel((Program)this.program, (Address)location, (TaskMonitor)monitor);
            }
            return func;
        }

        private boolean handleSimpleBlock(Address location, TaskMonitor monitor) throws CancelledException {
            SimpleBlockModel blockModel = new SimpleBlockModel(this.program);
            return this.resolveComputableFlow(location, monitor, (CodeBlockModel)blockModel);
        }

        private boolean resolveComputableFlow(Address location, TaskMonitor monitor, CodeBlockModel blockModel) throws CancelledException {
            CodeBlock jumpBlockAt = blockModel.getFirstCodeBlockContaining(location, monitor);
            final AtomicInteger foundCount = new AtomicInteger(0);
            SymbolicPropogator prop = new SymbolicPropogator(this.program, false);
            prop.flowConstants(jumpBlockAt.getFirstStartAddress(), (AddressSetView)jumpBlockAt, (ContextEvaluator)new ContextEvaluatorAdapter(){

                public boolean evaluateReference(VarnodeContext context, Instruction instr, int pcodeop, Address address, int size, DataType dataType, RefType refType) {
                    if (refType.isComputed() && refType.isFlow() && FindFunctionCallback.this.program.getMemory().contains(address)) {
                        foundCount.incrementAndGet();
                    }
                    return false;
                }
            }, false, monitor);
            return foundCount.get() == 1;
        }
    }
}

