/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.exceptionhandling;

import ghidra.app.cmd.data.AbstractCreateDataBackgroundCmd;
import ghidra.app.cmd.data.CreateTypeDescriptorBackgroundCmd;
import ghidra.app.cmd.data.EHDataTypeUtilities;
import ghidra.app.cmd.data.TypeDescriptorModel;
import ghidra.app.cmd.data.exceptionhandling.EHCatchHandlerModel;
import ghidra.app.util.datatype.microsoft.DataApplyOptions;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;

public class CreateEHCatchHandlerMapBackgroundCmd
extends AbstractCreateDataBackgroundCmd<EHCatchHandlerModel> {
    public CreateEHCatchHandlerMapBackgroundCmd(Address address, int count) {
        super("HandlerType", address, count);
    }

    public CreateEHCatchHandlerMapBackgroundCmd(Address address, int count, DataValidationOptions validationOptions, DataApplyOptions applyOptions) {
        super("HandlerType", address, count, validationOptions, applyOptions);
    }

    CreateEHCatchHandlerMapBackgroundCmd(EHCatchHandlerModel catchHandlerModel, DataApplyOptions applyOptions) {
        super(catchHandlerModel, applyOptions);
    }

    @Override
    protected EHCatchHandlerModel createModel(Program program) {
        if (this.model == null) {
            this.model = new EHCatchHandlerModel(program, this.count, this.getDataAddress(), this.validationOptions);
        }
        return (EHCatchHandlerModel)this.model;
    }

    @Override
    protected boolean createAssociatedData() throws CancelledException {
        return this.createTypeDescriptors();
    }

    private boolean createTypeDescriptors() throws CancelledException {
        this.monitor.setMessage("Creating TypeDescriptors for HandlerTypes");
        boolean result = true;
        Program program = ((EHCatchHandlerModel)this.model).getProgram();
        for (int catchHandlerOrdinal = 0; catchHandlerOrdinal < this.count; ++catchHandlerOrdinal) {
            TypeDescriptorModel typeDescriptorModel;
            Address typeDescriptorAddress;
            Address compAddress;
            this.monitor.checkCancelled();
            try {
                compAddress = ((EHCatchHandlerModel)this.model).getComponentAddressOfTypeDescriptorAddress(catchHandlerOrdinal);
                typeDescriptorAddress = ((EHCatchHandlerModel)this.model).getTypeDescriptorAddress(catchHandlerOrdinal);
            }
            catch (InvalidDataTypeException e) {
                throw new AssertException((Throwable)e);
            }
            if (typeDescriptorAddress == null) continue;
            try {
                typeDescriptorModel = ((EHCatchHandlerModel)this.model).getTypeDescriptorModel(catchHandlerOrdinal);
            }
            catch (InvalidDataTypeException e) {
                throw new AssertException((Throwable)e);
            }
            try {
                typeDescriptorModel.validate();
            }
            catch (InvalidDataTypeException e1) {
                this.handleErrorMessage(program, typeDescriptorModel.getName(), typeDescriptorModel.getAddress(), compAddress, (Exception)((Object)e1));
                result = false;
                continue;
            }
            int typeDescriptorCount = typeDescriptorModel.getCount();
            if (typeDescriptorCount == 0) continue;
            CreateTypeDescriptorBackgroundCmd cmd = new CreateTypeDescriptorBackgroundCmd(typeDescriptorModel, this.applyOptions);
            result &= cmd.applyTo(program, this.monitor);
        }
        return result;
    }

    @Override
    protected boolean createMarkup() throws CancelledException {
        return this.createHandlerRefsAndSymbols();
    }

    private boolean createHandlerRefsAndSymbols() throws CancelledException {
        this.monitor.setMessage("Creating catch handler markup");
        Program program = ((EHCatchHandlerModel)this.model).getProgram();
        boolean result = true;
        EHCatchHandlerModel catchHandlerModel = this.createModel(program);
        for (int catchHandlerOrdinal = 0; catchHandlerOrdinal < this.count; ++catchHandlerOrdinal) {
            boolean success;
            Address refAddress;
            Address compAddress;
            this.monitor.checkCancelled();
            try {
                compAddress = catchHandlerModel.getComponentAddressOfCatchHandlerAddress(catchHandlerOrdinal);
                refAddress = catchHandlerModel.getCatchHandlerAddress(catchHandlerOrdinal);
            }
            catch (InvalidDataTypeException e) {
                throw new AssertException((Throwable)e);
            }
            if (refAddress == null) continue;
            if (this.applyOptions.shouldCreateLabel()) {
                try {
                    String catchHandlerName = catchHandlerModel.getCatchHandlerName(catchHandlerOrdinal);
                    Symbol symbol = EHDataTypeUtilities.createSymbolIfNeeded(program, catchHandlerName, refAddress);
                    if (symbol == null) {
                        result = false;
                    }
                }
                catch (InvalidDataTypeException | InvalidInputException e) {
                    String message = "Couldn't create name for catch handler at " + refAddress.toString() + ".";
                    this.handleErrorMessage(program, compAddress, message + " " + e.getMessage(), message);
                    result = false;
                }
            }
            if (!this.applyOptions.shouldCreateFunction() || (success = EHDataTypeUtilities.createFunctionIfNeeded(program, refAddress))) continue;
            result = false;
        }
        return result;
    }
}

