/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.util.bin.format.pdb.PdbParser;
import ghidra.app.util.bin.format.pdb.WrappedDataType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXParseException;

class ApplyTypeDefs {
    private PdbParser pdbParser;
    private MessageLog log;
    private List<XmlElement> todo = new ArrayList<XmlElement>();

    ApplyTypeDefs(PdbParser pdbParser, XmlPullParser xmlParser, TaskMonitor monitor, MessageLog log) throws CancelledException, SAXParseException {
        this.pdbParser = pdbParser;
        this.log = log;
        this.preProcessTypedefList(xmlParser, monitor);
    }

    private void preProcessTypedefList(XmlPullParser xmlParser, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Pre-processing typedefs...");
        while (xmlParser.hasNext()) {
            monitor.checkCancelled();
            XmlElement elem = xmlParser.next();
            if (elem.isStart()) {
                this.todo.add(elem);
            }
            if (!elem.isEnd() || !elem.getName().equals("typedefs")) continue;
            break;
        }
    }

    void buildTypeDefs(TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Applying typedefs...");
        for (XmlElement elem : this.todo) {
            String baseDatatypeName;
            monitor.checkCancelled();
            String datatypeName = SymbolUtilities.replaceInvalidChars((String)elem.getAttribute("name"), (boolean)false);
            if (datatypeName.equals(baseDatatypeName = SymbolUtilities.replaceInvalidChars((String)elem.getAttribute("basetype"), (boolean)false)) || "Function".equals(baseDatatypeName)) continue;
            WrappedDataType baseDataType = this.pdbParser.findDataType(baseDatatypeName);
            if (baseDataType == null) {
                this.log.appendMsg("PDB", "Failed to resolve typedef: " + datatypeName + " -> " + baseDatatypeName);
                continue;
            }
            if (baseDataType.isZeroLengthArray()) {
                this.log.appendMsg("PDB", "Zero length array not supported for typedef: " + datatypeName);
                continue;
            }
            TypedefDataType typedef = this.pdbParser.createTypeDef(datatypeName, baseDataType.getDataType());
            this.pdbParser.cacheDataType(datatypeName, (DataType)typedef);
        }
    }
}

