/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model.columns;

import ghidra.app.plugin.core.debug.gui.model.ObjectTableModel;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueObjectPropertyColumn;
import ghidra.trace.model.TraceExecutionState;
import ghidra.trace.model.target.schema.SchemaContext;
import ghidra.trace.model.target.schema.TraceObjectSchema;

public class TraceValueObjectAttributeColumn<T>
extends TraceValueObjectPropertyColumn<T> {
    protected final String attributeName;

    public static Class<?> computeAttributeType(SchemaContext ctx, TraceObjectSchema.AttributeSchema attributeSchema) {
        TraceObjectSchema schema = ctx.getSchema(attributeSchema.getSchema());
        Class type = schema.getType();
        if (type == TraceExecutionState.class) {
            return String.class;
        }
        return type;
    }

    public TraceValueObjectAttributeColumn(String attributeName, Class<T> attributeType) {
        super(attributeType);
        this.attributeName = attributeName;
    }

    public String getColumnName() {
        return this.attributeName;
    }

    @Override
    public ObjectTableModel.ValueProperty<T> getProperty(ObjectTableModel.ValueRow row) {
        return row.getAttribute(this.attributeName, this.propertyType);
    }
}

