/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.protorules.DatatypeFilter;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class SizeRestrictedFilter
implements DatatypeFilter {
    public static final String NAME = "any";
    protected int minSize;
    protected int maxSize;
    protected HashSet<Integer> sizes = null;

    public SizeRestrictedFilter() {
        this.minSize = 0;
        this.maxSize = 0;
    }

    public SizeRestrictedFilter(int min, int max) {
        this.minSize = min;
        this.maxSize = max;
        if (this.maxSize == 0 && this.minSize >= 0) {
            this.maxSize = Integer.MAX_VALUE;
        }
    }

    public SizeRestrictedFilter(SizeRestrictedFilter op2) {
        this.minSize = op2.minSize;
        this.maxSize = op2.maxSize;
        this.sizes = op2.sizes != null ? new HashSet<Integer>(op2.sizes) : null;
    }

    protected void initFromSizeList(String str) throws XmlParseException {
        String[] numStrings = str.split(" +|,");
        this.sizes = new HashSet();
        this.minSize = Integer.MAX_VALUE;
        this.maxSize = 0;
        for (String valString : numStrings) {
            int val = Integer.parseInt(valString);
            if (val <= 0) {
                throw new XmlParseException("Bad filter size");
            }
            this.sizes.add(val);
            if (val < this.minSize) {
                this.minSize = val;
            }
            if (val <= this.maxSize) continue;
            this.maxSize = val;
        }
        if (this.sizes.isEmpty()) {
            this.sizes = null;
            this.minSize = 0;
            this.maxSize = 0;
        }
    }

    public boolean filterOnSize(DataType dt) {
        if (this.maxSize == 0) {
            return true;
        }
        if (this.sizes != null) {
            return this.sizes.contains(dt.getLength());
        }
        return dt.getLength() >= this.minSize && dt.getLength() <= this.maxSize;
    }

    @Override
    public DatatypeFilter clone() {
        return new SizeRestrictedFilter(this);
    }

    @Override
    public boolean isEquivalent(DatatypeFilter op) {
        if (this.getClass() != op.getClass()) {
            return false;
        }
        SizeRestrictedFilter otherFilter = (SizeRestrictedFilter)op;
        if (this.maxSize != otherFilter.maxSize || this.minSize != otherFilter.minSize) {
            return false;
        }
        return !(this.sizes != null && otherFilter.sizes != null ? !this.sizes.equals(otherFilter.sizes) : this.sizes != null || otherFilter.sizes != null);
    }

    @Override
    public boolean filter(DataType dt) {
        return this.filterOnSize(dt);
    }

    protected void encodeAttributes(Encoder encoder) throws IOException {
        if (this.sizes != null) {
            StringBuilder buffer = new StringBuilder();
            Iterator<Integer> iter = this.sizes.iterator();
            buffer.append(iter.next());
            while (iter.hasNext()) {
                buffer.append(',');
                buffer.append(iter.next());
            }
            encoder.writeString(AttributeId.ATTRIB_SIZES, buffer.toString());
        } else {
            encoder.writeUnsignedInteger(AttributeId.ATTRIB_MINSIZE, this.minSize);
            encoder.writeUnsignedInteger(AttributeId.ATTRIB_MAXSIZE, this.maxSize);
        }
    }

    protected void restoreAttributesXml(XmlElement el) throws XmlParseException {
        for (Map.Entry attrib : el.getAttributes().entrySet()) {
            String nm = (String)attrib.getKey();
            if (nm.equals(AttributeId.ATTRIB_MINSIZE.name())) {
                if (this.sizes != null) {
                    throw new XmlParseException("Mixing \"sizes\" with \"minsize\" and \"maxsize\"");
                }
                this.minSize = SpecXmlUtils.decodeInt((String)((String)attrib.getValue()));
                continue;
            }
            if (nm.equals(AttributeId.ATTRIB_MAXSIZE.name())) {
                if (this.sizes != null) {
                    throw new XmlParseException("Mixing \"sizes\" with \"minsize\" and \"maxsize\"");
                }
                this.maxSize = SpecXmlUtils.decodeInt((String)((String)attrib.getValue()));
                continue;
            }
            if (!nm.equals(AttributeId.ATTRIB_SIZES.name())) continue;
            if (this.minSize != 0 || this.maxSize != 0) {
                throw new XmlParseException("Mixing \"sizes\" with \"minsize\" and \"maxsize\"");
            }
            String sizeList = (String)attrib.getValue();
            this.initFromSizeList(sizeList);
        }
        if (this.maxSize == 0 && this.minSize >= 0) {
            this.maxSize = Integer.MAX_VALUE;
        }
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_DATATYPE);
        encoder.writeString(AttributeId.ATTRIB_NAME, NAME);
        this.encodeAttributes(encoder);
        encoder.closeElement(ElementId.ELEM_DATATYPE);
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws XmlParseException {
        XmlElement elem = parser.start(new String[]{ElementId.ELEM_DATATYPE.name()});
        this.restoreAttributesXml(elem);
        parser.end(elem);
    }
}

