/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.generic;

import ghidra.framework.store.LockException;
import ghidra.program.database.mem.ByteMappingScheme;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.InvalidAddressException;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryConflictException;
import ghidra.util.XmlProgramUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlAttributeException;
import ghidra.util.xml.XmlUtilities;
import ghidra.xml.XmlElement;

public class MemoryBlockDefinition {
    private String blockName;
    private String addressString;
    private int length;
    private boolean initialized;
    private boolean overlay;
    private String bitMappedAddress;
    private String byteMappedAddress;
    private ByteMappingScheme byteMappingScheme;
    private boolean readPermission = true;
    private boolean writePermission = true;
    private boolean executePermission = false;
    private boolean isVolatile = false;

    private MemoryBlockDefinition(String blockName, String addressString, String bitMappedAddress, String byteMappedAddressRatio, String mode, String lengthString, String initializedString, String overlayString) throws XmlAttributeException {
        this.blockName = blockName;
        this.addressString = addressString;
        this.bitMappedAddress = bitMappedAddress;
        if (byteMappedAddressRatio != null) {
            if (bitMappedAddress != null) {
                throw new XmlAttributeException("may not specify both bit_mapped_address and byte_mapped_address");
            }
            int index = byteMappedAddressRatio.indexOf(47);
            if (index > 0) {
                this.byteMappingScheme = new ByteMappingScheme(byteMappedAddressRatio.substring(index + 1));
                this.byteMappedAddress = byteMappedAddressRatio.substring(0, index);
            } else {
                this.byteMappedAddress = byteMappedAddressRatio;
            }
        }
        if (mode != null) {
            this.readPermission = (mode = mode.toLowerCase()).indexOf(114) >= 0;
            this.writePermission = mode.indexOf(119) >= 0;
            this.executePermission = mode.indexOf(120) >= 0;
            this.isVolatile = mode.indexOf(118) >= 0;
        }
        try {
            this.length = XmlUtilities.parseInt((String)lengthString);
        }
        catch (NumberFormatException e) {
            throw new XmlAttributeException(lengthString + " is not a valid integer");
        }
        if (initializedString != null) {
            if (bitMappedAddress != null || this.byteMappedAddress != null) {
                throw new XmlAttributeException("mapped block specifications must not specify initialized attribute");
            }
            this.initialized = XmlUtilities.parseBoolean((String)initializedString);
        }
        this.overlay = XmlUtilities.parseBoolean((String)overlayString);
    }

    public MemoryBlockDefinition(XmlElement element) throws XmlAttributeException {
        this(element.getAttribute("name"), element.getAttribute("start_address"), element.getAttribute("bit_mapped_address"), element.getAttribute("byte_mapped_address"), element.getAttribute("mode"), element.getAttribute("length"), element.getAttribute("initialized"), element.getAttribute("overlay"));
    }

    private static Address parseAddress(String addressString, Program program, String description) throws InvalidAddressException {
        Address addr = XmlProgramUtilities.parseAddress(program.getAddressFactory(), addressString);
        if (addr == null) {
            throw new InvalidAddressException("Invalid " + description + " in memory block definition: " + addressString);
        }
        return addr;
    }

    public void createBlock(Program program) throws LockException, MemoryConflictException, AddressOverflowException, InvalidAddressException {
        MemoryBlock block;
        if (this.blockName == null || this.addressString == null || this.length <= 0) {
            return;
        }
        Memory mem = program.getMemory();
        Address addr = MemoryBlockDefinition.parseAddress(this.addressString, program, "block address");
        if (this.bitMappedAddress != null) {
            Address mappedAddr = MemoryBlockDefinition.parseAddress(this.bitMappedAddress, program, "bit-mapped address");
            block = mem.createBitMappedBlock(this.blockName, addr, mappedAddr, this.length, this.overlay);
        } else if (this.byteMappedAddress != null) {
            Address mappedAddr = MemoryBlockDefinition.parseAddress(this.byteMappedAddress, program, "byte-mapped address");
            block = mem.createByteMappedBlock(this.blockName, addr, mappedAddr, this.length, this.byteMappingScheme, this.overlay);
        } else if (this.initialized) {
            try {
                block = mem.createInitializedBlock(this.blockName, addr, this.length, (byte)0, TaskMonitor.DUMMY, this.overlay);
            }
            catch (CancelledException e) {
                throw new AssertException((Throwable)e);
            }
        } else {
            block = mem.createUninitializedBlock(this.blockName, addr, this.length, this.overlay);
        }
        block.setRead(this.readPermission);
        block.setWrite(this.writePermission);
        block.setExecute(this.executePermission);
        block.setVolatile(this.isVolatile);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.blockName);
        buf.append(':');
        if (this.overlay) {
            buf.append("overlay");
        }
        buf.append(" start_address=");
        buf.append(this.addressString);
        if (this.initialized) {
            buf.append(", initialized ");
        } else if (this.bitMappedAddress != null) {
            buf.append(", bit_mapped_address=");
            buf.append(this.bitMappedAddress);
        } else if (this.byteMappedAddress != null) {
            buf.append(", byte_mapped_address=");
            buf.append(this.byteMappedAddress);
            if (this.byteMappingScheme != null) {
                buf.append('/');
                buf.append(this.byteMappingScheme.toString());
            }
        } else {
            buf.append(", uninitialized");
        }
        buf.append(", length=0x");
        buf.append(Integer.toHexString(this.length));
        return buf.toString();
    }
}

