/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootimg;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.bootimg.BootImageHeaderV0;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class BootImageHeaderV1
extends BootImageHeaderV0 {
    private int recovery_dtbo_size;
    private long recovery_dtbo_offset;
    private int header_size;

    public BootImageHeaderV1(BinaryReader reader) throws IOException {
        super(reader);
        this.recovery_dtbo_size = reader.readNextInt();
        this.recovery_dtbo_offset = reader.readNextLong();
        this.header_size = reader.readNextInt();
    }

    public int getRecoveryDtboSize() {
        return this.recovery_dtbo_size;
    }

    public int getRecoveryDtboSizeAdjusted() {
        return (int)(this.pageAlign(Integer.toUnsignedLong(this.recovery_dtbo_size)) / (long)this.getPageSize());
    }

    public long getRecoveryDtboOffset() {
        return this.recovery_dtbo_offset;
    }

    public int getHeaderSize() {
        return this.header_size;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        Structure structure = (Structure)super.toDataType();
        try {
            structure.setName("boot_img_hdr_v1");
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        structure.add(DWORD, "recovery_dtbo_size", null);
        structure.add(QWORD, "recovery_dtbo_offset", null);
        structure.add(DWORD, "header_size", null);
        return structure;
    }
}

